/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware.massStorage;

import jace.apple2e.MOS65C02;
import jace.apple2e.SoftSwitches;
import jace.config.ConfigurableField;
import jace.config.Name;
import jace.config.Reconfigurable;
import jace.core.Card;
import jace.core.Computer;
import jace.core.Motherboard;
import jace.core.RAM;
import jace.core.RAMEvent;
import jace.core.RAMListener;
import jace.hardware.massStorage.IDisk;
import jace.hardware.massStorage.LargeDisk;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

@Name(value="Mass Storage Device")
public class CardMassStorage
extends Card
implements Reconfigurable {
    static int SLT16 = 43;
    static int DEVICE_DRIVER_OFFSET = 10;
    static int MLI_COMMAND = 66;
    static int MLI_UNITNUMBER = 67;
    static int MLI_BUFFER_ADDRESS = 68;
    static int MLI_BLOCK_NUMBER = 70;
    IDisk disk1;
    IDisk disk2;
    @ConfigurableField(name="Drive 1")
    public File disk1path = null;
    @ConfigurableField(name="Drive 2")
    public File disk2path = null;
    byte[] cardSignature = new byte[]{-87, 32, -87, 0, -87, 3, -87, 60, -48, 7, 96, -80, 1, 24, -80, 90};
    private RAMListener memoryListener;

    public String getName() {
        return "Mass Storage Device (Slot " + this.getSlot() + ")";
    }

    public void reconfigure() {
        try {
            this.disconnect();
            if (this.disk1path == null) {
                if (this.disk1 != null) {
                    this.disk1.eject();
                    this.disk1 = null;
                }
            } else if (this.disk1 == null) {
                this.disk1 = this.readDisk(this.disk1path);
            } else if (!this.disk1.getPhysicalPath().equals(this.disk1path)) {
                this.disk1.eject();
                this.disk1 = this.readDisk(this.disk1path);
            }
            if (this.disk2path == null) {
                if (this.disk2 != null) {
                    this.disk2.eject();
                    this.disk2 = null;
                }
            } else if (this.disk2 == null) {
                this.disk2 = this.readDisk(this.disk2path);
            } else if (!this.disk2.getPhysicalPath().equals(this.disk2path)) {
                this.disk2.eject();
                this.disk2 = this.readDisk(this.disk2path);
            }
            int pc = Computer.getComputer().getCpu().getProgramCounter();
            if (this.disk1 != null && this.getSlot() == 7 && (pc == 50782 || pc == 50785)) {
                this.disk1.boot0(this.getSlot());
                Motherboard.cancelSpeedRequest(Motherboard.cards[6]);
            }
            this.registerListeners();
            this.registerCustomListeners();
        }
        catch (IOException ex) {
            Logger.getLogger(CardMassStorage.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void disconnect() {
        this.removeListeners();
        this.removeCustomListeners();
    }

    private IDisk readDisk(File f) {
        return new LargeDisk(f);
    }

    public void reset() {
    }

    protected void registerCustomListeners() {
        int slot = this.getSlot();
        this.disconnect();
        this.memoryListener = new RAMListener(RAMEvent.TYPE.ANY, RAMEvent.SCOPE.RANGE, RAMEvent.VALUE.ANY){

            protected void doConfig() {
                this.setScopeStart(49152 + CardMassStorage.this.getSlot() * 256);
                this.setScopeEnd(49407 + CardMassStorage.this.getSlot() * 256);
            }

            protected void doEvent(RAMEvent e) {
                if (SoftSwitches.CXROM.getState()) {
                    return;
                }
                MOS65C02 cpu = (MOS65C02)Computer.getComputer().getCpu();
                if (e.getType() == RAMEvent.TYPE.READ) {
                    int offset = e.getAddress() & 0xFF;
                    if (cpu.getProgramCounter() == e.getAddress()) {
                        String error = null;
                        if (offset == 0) {
                            e.setNewValue(234);
                            try {
                                if (CardMassStorage.this.disk1 != null) {
                                    CardMassStorage.this.disk1.boot0(CardMassStorage.this.getSlot());
                                }
                                return;
                            }
                            catch (IOException ex) {
                                Logger.getLogger(CardMassStorage.class.getName()).log(Level.SEVERE, null, ex);
                                error = ex.getMessage();
                                cpu.setProgramCounter(57343);
                                int address = 1152;
                                for (char c : error.toCharArray()) {
                                    Computer.getComputer().getMemory().write(address++, (byte)(c + 128), false);
                                }
                            }
                        } else {
                            if (offset == DEVICE_DRIVER_OFFSET) {
                                int returnCode;
                                cpu.A = returnCode = ((CardMassStorage)CardMassStorage.this).prodosMLI().intValue;
                                cpu.C = returnCode == 0 ? 0 : 1;
                            } else {
                                System.out.println("Call to unknown handler " + Integer.toString(e.getAddress(), 16) + "-- returning");
                            }
                            e.setNewValue(96);
                        }
                    }
                    if (offset < 16) {
                        e.setNewValue(CardMassStorage.this.cardSignature[offset]);
                    } else {
                        switch (offset) {
                            case 252: {
                                e.setNewValue(255);
                                break;
                            }
                            case 253: {
                                e.setNewValue(127);
                                break;
                            }
                            case 254: {
                                e.setNewValue(215);
                                break;
                            }
                            case 255: {
                                e.setNewValue(DEVICE_DRIVER_OFFSET);
                            }
                        }
                    }
                }
            }
        };
        Computer.getComputer().getMemory().addListener(this.memoryListener);
    }

    protected void removeCustomListeners() {
        if (this.memoryListener != null) {
            Computer.getComputer().getMemory().removeListener(this.memoryListener);
        }
    }

    protected void handleIOAccess(int register, RAMEvent.TYPE type, int value, RAMEvent e) {
    }

    public void motherboardTick() {
    }

    private MLI_RETURN prodosMLI() {
        try {
            IDisk disk;
            RAM memory = Computer.getComputer().getMemory();
            MLI_COMMAND_TYPE command = MLI_COMMAND_TYPE.fromInt(memory.read(MLI_COMMAND, false));
            boolean unit = (memory.readWord(MLI_UNITNUMBER, false) & 0x80) > 0;
            IDisk iDisk = disk = !unit ? this.disk1 : this.disk2;
            if (disk == null) {
                return MLI_RETURN.IO_ERROR;
            }
            int block = memory.readWord(MLI_BLOCK_NUMBER, false);
            int bufferAddress = memory.readWord(MLI_BUFFER_ADDRESS, false);
            if (command == null) {
                System.out.println("Mass storage given bogus command, returning I/O error");
                return MLI_RETURN.IO_ERROR;
            }
            switch (command) {
                case FORMAT: {
                    disk.mliFormat();
                }
                case READ: {
                    disk.mliRead(block, bufferAddress);
                    break;
                }
                case WRITE: {
                    disk.mliWrite(block, bufferAddress);
                    break;
                }
                default: {
                    System.out.println("Mass storage given bogus command, returning I/O error");
                    return MLI_RETURN.IO_ERROR;
                }
            }
            return MLI_RETURN.NO_ERROR;
        }
        catch (UnsupportedOperationException ex) {
            return MLI_RETURN.WRITE_PROTECTED;
        }
        catch (IOException ex) {
            System.out.println("Encountered IO Error, returning error: " + ex.getMessage());
            return MLI_RETURN.IO_ERROR;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MLI_COMMAND_TYPE {
        STATUS(0),
        READ(1),
        WRITE(2),
        FORMAT(3);

        public int intValue;

        private MLI_COMMAND_TYPE(int val) {
            this.intValue = val;
        }

        public static MLI_COMMAND_TYPE fromInt(int value) {
            for (MLI_COMMAND_TYPE c : MLI_COMMAND_TYPE.values()) {
                if (c.intValue != value) continue;
                return c;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MLI_RETURN {
        NO_ERROR(0),
        IO_ERROR(39),
        NO_DEVICE(40),
        WRITE_PROTECTED(43);

        public int intValue;

        private MLI_RETURN(int val) {
            this.intValue = val;
        }
    }
}

